function box = make_box3(points)
eps=10^-3;
dim=2;

N=size(points,1);
num_of_points=round(N^(1/dim));

meanval=mean(points,1);
medianval=median(points,1);

%range=1.5*sqrt(diag(eigval)/N);
%pom=points*eigvec/2;
%range=min((max(pom)-min(pom))',range);
%range=(max(points)-min(points))';
range=min(2*medianval',meanval');
%range=max(points)'/2;
range=min(range,[50; 15]);

box=zeros(N,dim);
pointer=[eps;eps];
step=2*range/(num_of_points-1);
jump=[1 num_of_points ];
for i=1:N
    for k=1:dim
        box(i,k)=pointer(k)+step(k)*mod(floor((i-1)/jump(k)),num_of_points);
    end
end  

%plot(box(:,1), box(:,2),'b.' ); hold on; plot(meanval(:,1), meanval(:,2), 'g+' );plot(points(:,1), points(:,2), 'r.' ); hold off
end